msOrderFields.grid.Fields = function (config) {
    config = config || {};
    if (!config.id) {
        config.id = 'msorderfields-grid-fields';
    }
    Ext.applyIf(config, {
        url: msOrderFields.config.connector_url,
        fields: this.getFields(config),
        columns: this.getColumns(config),
        tbar: this.getTopBar(config),
        sm: new Ext.grid.CheckboxSelectionModel(),
        baseParams: {
            action: 'mgr/fields/getlist',
            sort: 'rank',
            dir: 'asc',
            group: MODx.request.id || 0,
        },
        multi_select: true,
        changed: false,
        stateful: true,
        stateId: config.id,
        ddGroup: 'msorderfields-grid-fieldsDD',
        ddAction: 'mgr/fields/sort',
        enableDragDrop: true,
        listeners: {
            rowDblClick: function (grid, rowIndex, e) {
                var row = grid.store.getAt(rowIndex);
                this.updateField(grid, e, row);
            }
        },
        paging: true,
        remoteSort: true,
        autoHeight: true,
    });
    msOrderFields.grid.Fields.superclass.constructor.call(this, config);

    // Clear selection on grid refresh
    this.store.on('load', function () {
        if (this._getSelectedIds().length) {
            this.getSelectionModel().clearSelections();
        }
    }, this);
};
Ext.extend(msOrderFields.grid.Fields, msOrderFields.grid.Default, {
    windows: {},

    getFields: function () {
        return ['id', 'name', 'lexicon', 'lexicon_frontend', 'active', 'actions'];
    },

    getColumns: function () {
        return [{
            header: _('msorderfields_id'),
            dataIndex: 'id',
            sortable: true,
            width: 70
        }, {
            header: _('msorderfields_fields_name'),
            dataIndex: 'name',
            sortable: true,
            width: 100,
        }, {
            header: _('msorderfields_lexicon'),
            dataIndex: 'lexicon',
            sortable: false,
            width: 180,
        }, {
            header: _('msorderfields_lexicon_frontend'),
            dataIndex: 'lexicon_frontend',
            sortable: false,
            width: 180,
        }, {
            header: _('msorderfields_active'),
            dataIndex: 'active',
            renderer: msOrderFields.utils.renderBoolean,
            sortable: true,
            width: 100,
        }, {
            header: _('msorderfields_grid_actions'),
            dataIndex: 'actions',
            renderer: msOrderFields.utils.renderActions,
            sortable: false,
            width: 100,
            id: 'actions'
        }];
    },

    createField: function (btn, e) {
        var w = MODx.load({
            xtype: 'msorderfields-fields-window-create',
            id: Ext.id(),
            listeners: {
                success: {
                    fn: function () {
                        this.refresh();
                    }, scope: this
                }
            }
        });
        w.reset();
        w.setValues({active: true});
        w.show(e.target);
    },

    updateField: function (btn, e, row) {
        if (typeof(row) != 'undefined') {
            this.menu.record = row.data;
        }
        else if (!this.menu.record) {
            return false;
        }
        var id = this.menu.record.id;

        MODx.Ajax.request({
            url: this.config.url,
            params: {
                action: 'mgr/fields/get',
                id: id
            },
            listeners: {
                success: {
                    fn: function (r) {
                        var w = MODx.load({
                            xtype: 'msorderfields-fields-window-update',
                            id: Ext.id(),
                            record: r,
                            listeners: {
                                success: {
                                    fn: function () {
                                        this.refresh();
                                    }, scope: this
                                }
                            }
                        });
                        w.reset();
                        w.setValues(r.object);
                        w.show(e.target);
                    }, scope: this
                }
            }
        });
    },

    enableField: function () {
        this.orderAction('enable');
    },

    disableField: function () {
        this.orderAction('disable');
    },

    removeField: function () {
        var ids = this._getSelectedIds();

        Ext.MessageBox.confirm(
            _('msorderfields_remove'),
            _('msorderfields_remove_confirm'),
            function (val) {
                if (val == 'yes') {
                    this.orderAction('remove');
                }
            }, this
        );
    },

    orderAction: function (method) {
        var ids = this._getSelectedIds();
        if (!ids.length) {
            return false;
        }
        MODx.Ajax.request({
            url: this.config.url,
            params: {
                action: 'mgr/fields/multiple',
                method: method,
                ids: Ext.util.JSON.encode(ids),
            },
            listeners: {
                success: {
                    fn: function () {
                        //noinspection JSUnresolvedFunction
                        this.refresh();
                    }, scope: this
                },
                failure: {
                    fn: function (response) {
                        MODx.msg.alert(_('error'), response.message);
                    }, scope: this
                },
            }
        })
    },

    getTopBar: function () {
        return [{
            text: '<i class="icon icon-plus"></i>&nbsp;' + _('msorderfields_fields_create'),
            handler: this.createField,
            scope: this
        }, '->', {
            emptyText: _('msorderfields_filter_on_group'),
            xtype: 'msorderfields-combo-groups',
            id: 'msorderfields-filter-group',
            listeners: {
                select: {fn: function(combo, record) {
                        this.getStore().baseParams['group'] = record.id;
                        this.getBottomToolbar().changePage(1);
                    }, scope: this}
            },
            width: 250
        }, {
            xtype: 'msorderfields-field-search',
            width: 250,
            listeners: {
                search: {
                    fn: function (field) {
                        this._doSearch(field);
                    }, scope: this
                },
                clear: {
                    fn: function (field) {
                        field.setValue('');
                        this._clearSearch();
                    }, scope: this
                },
            }
        }];
    },

});
Ext.reg('msorderfields-grid-fields', msOrderFields.grid.Fields);
