msOrderFields.window.CreateField = function (config) {
    config = config || {};
    if (!config.id) {
        config.id = 'msorderfields-fields-window-create';
    }
    Ext.applyIf(config, {
        title: _('msorderfields_fields_create'),
        width: 550,
        autoHeight: true,
        url: msOrderFields.config.connector_url,
        action: 'mgr/fields/create',
        fields: this.getFields(config),
        keys: [{
            key: Ext.EventObject.ENTER, shift: true, fn: function () {
                this.submit()
            }, scope: this
        }]
    });
    msOrderFields.window.CreateField.superclass.constructor.call(this, config);
};
Ext.extend(msOrderFields.window.CreateField, MODx.Window, {

    getFields: function (config) {
        var all = {
            receiver: {},
            phone: {},
            index: {},
            country: {},
            region: {},
            metro: {},
            building: {},
            city: {},
            street: {},
            room: {},
            comment: {}
        };
        var editable = config.record ? (all[config.record.object.name] ? true : false) : false;

        var group = {
            xtype: 'msorderfields-combo-groups',
            fieldLabel: _('msorderfields_group'),
            name: 'group',
            id: config.id + '-group',
            anchor: '99%',
            allowBlank: false,
            listeners: {
                render: function(group){
                    if(MODx.request.id) {
                        group.setValue(MODx.request.id);
                        group.setReadOnly(true);
                    }
                    if(editable) {
                        group.setReadOnly(true);
                    }
                }
            }
        };

        return [{
            xtype: 'hidden',
            name: 'id',
            id: config.id + '-id',
        }, {
            layout: 'column',
            items: [{
                columnWidth: .5,
                layout: 'form',
                defaults: {msgTarget: 'under'},
                items:[{
                    xtype: 'textfield',
                    fieldLabel: _('msorderfields_fields_name'),
                    name: 'name',
                    id: config.id + '-name',
                    anchor: '99%',
                    allowBlank: false,
                    listeners: {
                        render: function(name){
                            if(editable) {
                                name.setReadOnly(true);
                            }
                        }
                    }
                }, group, {
                    xtype: 'textfield',
                    fieldLabel: _('msorderfields_lexicon'),
                    name: 'lexicon',
                    id: config.id + '-lexicon',
                    anchor: '99%',
                    allowBlank: false,
                }]
            }, {
                columnWidth: .5,
                layout: 'form',
                defaults: {msgTarget: 'under'},
                items:[{
                    xtype: editable ? 'msorderfields-combo-types-order' : 'msorderfields-combo-types',
                    fieldLabel: _('msorderfields_fields_xtype'),
                    name: 'xtype',
                    hiddenName: 'xtype',
                    id: config.id + '-xtype',
                    anchor: '99%',
                    allowBlank: false,
                    listeners: {
                        render: function(xtype){
                            if(Ext.isEmpty(xtype.value)) {
                                xtype.setValue('textfield');
                            }
                        }
                    }
                }, {
                    xtype: 'numberfield',
                    fieldLabel: _('msorderfields_fields_size'),
                    description: _('msorderfields_fields_size_desc'),
                    name: 'size',
                    id: config.id + '-size',
                    anchor: '99%',
                    allowBlank: false,
                    value: 50,
                    maxValue: 100,
                    minValue: 0,
                    listeners: {
                        render: function(size){
                            if(Ext.isEmpty(size.value)) {
                                size.setValue(50);
                            }
                        }
                    }
                }, {
                    xtype: 'textfield',
                    fieldLabel: _('msorderfields_lexicon_frontend'),
                    name: 'lexicon_frontend',
                    id: config.id + '-lexicon_frontend',
                    anchor: '99%',
                    allowBlank: false,
                }]
            }]
        }, {
            xtype: 'checkboxgroup',
            hideLabel: true,
            name: 'checkboxgroup',
            columns: 3,
            items: [{
                xtype: 'xcheckbox',
                boxLabel: _('msorderfields_active'),
                name: 'active',
                id: config.id + '-active',
                checked: config.record ? config.record.object['active'] : true,
            }, {
                xtype: 'xcheckbox',
                boxLabel: _('msorderfields_fields_required'),
                name: 'required',
                id: config.id + '-required',
                checked: config.record ? config.record.object['required'] : false,
            }]
        }];
    },

    loadDropZones: function () {
    }

});
Ext.reg('msorderfields-fields-window-create', msOrderFields.window.CreateField);


msOrderFields.window.UpdateField = function (config) {
    config = config || {};
    if (!config.id) {
        config.id = 'msorderfields-fields-window-update';
    }
    Ext.applyIf(config, {
        title: _('msorderfields_update'),
        width: 550,
        autoHeight: true,
        url: msOrderFields.config.connector_url,
        action: 'mgr/fields/update',
        fields: this.getFields(config),
        keys: [{
            key: Ext.EventObject.ENTER, shift: true, fn: function () {
                this.submit()
            }, scope: this
        }]
    });
    msOrderFields.window.UpdateField.superclass.constructor.call(this, config);
};
Ext.extend(msOrderFields.window.UpdateField, msOrderFields.window.CreateField);
Ext.reg('msorderfields-fields-window-update', msOrderFields.window.UpdateField);