msOrderFields.grid.Groups = function (config) {
    config = config || {};
    if (!config.id) {
        config.id = 'msorderfields-grid-groups';
    }
    Ext.applyIf(config, {
        url: msOrderFields.config.connector_url,
        fields: this.getFields(config),
        columns: this.getColumns(config),
        tbar: this.getTopBar(config),
        sm: new Ext.grid.CheckboxSelectionModel(),
        baseParams: {
            action: 'mgr/groups/getlist',
            sort: 'rank',
            dir: 'asc',
        },
        multi_select: true,
        changed: false,
        stateful: true,
        stateId: config.id,
        ddGroup: 'quiz-grid-groupsDD',
        ddAction: 'mgr/groups/sort',
        enableDragDrop: true,
        listeners: {
            rowDblClick: function (grid, rowIndex, e) {
                var row = grid.store.getAt(rowIndex);
                this.updateGroup(grid, e, row);
            }
        },
        paging: true,
        remoteSort: true,
        autoHeight: true,
    });
    msOrderFields.grid.Groups.superclass.constructor.call(this, config);

    // Clear selection on grid refresh
    this.store.on('load', function () {
        if (this._getSelectedIds().length) {
            this.getSelectionModel().clearSelections();
        }
    }, this);
};
Ext.extend(msOrderFields.grid.Groups, msOrderFields.grid.Default, {
    windows: {},

    getFields: function () {
        return ['id', 'name', 'description', 'active', 'actions'];
    },

    getColumns: function () {
        return [{
            header: _('msorderfields_id'),
            dataIndex: 'id',
            sortable: true,
            width: 70
        }, {
            header: _('msorderfields_groups_name'),
            dataIndex: 'name',
            sortable: true,
            width: 100,
        }, {
            header: _('msorderfields_description'),
            dataIndex: 'description',
            sortable: true,
            width: 300,
        }, {
            header: _('msorderfields_active'),
            dataIndex: 'active',
            renderer: msOrderFields.utils.renderBoolean,
            sortable: true,
            width: 250,
        }, {
            header: _('msorderfields_grid_actions'),
            dataIndex: 'actions',
            renderer: msOrderFields.utils.renderActions,
            sortable: false,
            width: 80,
            id: 'actions'
        }];
    },

    createGroup: function (btn, e) {
        var w = MODx.load({
            xtype: 'msorderfields-groups-window-create',
            id: Ext.id(),
            listeners: {
                success: {
                    fn: function () {
                        this.refresh();
                    }, scope: this
                }
            }
        });
        w.reset();
        w.setValues({active: true});
        w.show(e.target);
    },

    viewGroup: function (btn, e, row) {
        MODx.loadPage('update', 'namespace=' + MODx.request.namespace + '&id=' + this.menu.record.id);
    },

    updateGroup: function (btn, e, row) {
        if (typeof(row) != 'undefined') {
            this.menu.record = row.data;
        }
        else if (!this.menu.record) {
            return false;
        }
        var id = this.menu.record.id;

        MODx.Ajax.request({
            url: this.config.url,
            params: {
                action: 'mgr/groups/get',
                id: id
            },
            listeners: {
                success: {
                    fn: function (r) {
                        var w = MODx.load({
                            xtype: 'msorderfields-groups-window-update',
                            id: Ext.id(),
                            record: r,
                            listeners: {
                                success: {
                                    fn: function () {
                                        this.refresh();
                                    }, scope: this
                                }
                            }
                        });
                        w.reset();
                        w.setValues(r.object);
                        w.show(e.target);
                    }, scope: this
                }
            }
        });
    },

    enableGroup: function () {
        this.orderAction('enable');
    },

    disableGroup: function () {
        this.orderAction('disable');
    },

    removeGroup: function () {
        var ids = this._getSelectedIds();

        Ext.MessageBox.confirm(
            _('msorderfields_remove'),
            _('msorderfields_remove_confirm'),
            function (val) {
                if (val == 'yes') {
                    this.orderAction('remove');
                }
            }, this
        );
    },

    orderAction: function (method) {
        var ids = this._getSelectedIds();
        if (!ids.length) {
            return false;
        }
        MODx.Ajax.request({
            url: this.config.url,
            params: {
                action: 'mgr/groups/multiple',
                method: method,
                ids: Ext.util.JSON.encode(ids),
            },
            listeners: {
                success: {
                    fn: function () {
                        //noinspection JSUnresolvedFunction
                        this.refresh();
                    }, scope: this
                },
                failure: {
                    fn: function (response) {
                        MODx.msg.alert(_('error'), response.message);
                    }, scope: this
                },
            }
        })
    },

    getTopBar: function () {
        return [{
            text: '<i class="icon icon-plus"></i>&nbsp;' + _('msorderfields_groups_create'),
            handler: this.createGroup,
            scope: this
        }, '->', {
            xtype: 'msorderfields-field-search',
            width: 250,
            listeners: {
                search: {
                    fn: function (field) {
                        this._doSearch(field);
                    }, scope: this
                },
                clear: {
                    fn: function (field) {
                        field.setValue('');
                        this._clearSearch();
                    }, scope: this
                },
            }
        }];
    },

});
Ext.reg('msorderfields-grid-groups', msOrderFields.grid.Groups);
