msOrderFields.window.CreateGroup = function (config) {
    config = config || {};
    if (!config.id) {
        config.id = 'msorderfields-groups-window-create';
    }
    Ext.applyIf(config, {
        title: _('msorderfields_groups_create'),
        width: 550,
        autoHeight: true,
        url: msOrderFields.config.connector_url,
        action: 'mgr/groups/create',
        fields: this.getFields(config),
        keys: [{
            key: Ext.EventObject.ENTER, shift: true, fn: function () {
                this.submit()
            }, scope: this
        }]
    });
    msOrderFields.window.CreateGroup.superclass.constructor.call(this, config);
};
Ext.extend(msOrderFields.window.CreateGroup, MODx.Window, {

    getFields: function (config) {
        return [{
            xtype: 'hidden',
            name: 'id',
            id: config.id + '-id',
        }, {
            xtype: 'textfield',
            fieldLabel: _('msorderfields_groups_name'),
            name: 'name',
            id: config.id + '-name',
            anchor: '99%',
            allowBlank: false,
        }, {
            xtype: 'textarea',
            fieldLabel: _('msorderfields_description'),
            name: 'description',
            id: config.id + '-description',
            anchor: '99%',
            height: 170,
            allowBlank: true,
        }, {
            xtype: 'xcheckbox',
            boxLabel: _('msorderfields_active'),
            name: 'active',
            id: config.id + '-active',
            checked: config.record ? config.record.object['active'] : true,
        }];
    },

    loadDropZones: function () {
    }

});
Ext.reg('msorderfields-groups-window-create', msOrderFields.window.CreateGroup);


msOrderFields.window.UpdateField = function (config) {
    config = config || {};
    if (!config.id) {
        config.id = 'msorderfields-groups-window-update';
    }
    Ext.applyIf(config, {
        title: _('msorderfields_update'),
        width: 550,
        autoHeight: true,
        url: msOrderFields.config.connector_url,
        action: 'mgr/groups/update',
        fields: this.getFields(config),
        keys: [{
            key: Ext.EventObject.ENTER, shift: true, fn: function () {
                this.submit()
            }, scope: this
        }]
    });
    msOrderFields.window.UpdateField.superclass.constructor.call(this, config);
};
Ext.extend(msOrderFields.window.UpdateField, msOrderFields.window.CreateGroup);
Ext.reg('msorderfields-groups-window-update', msOrderFields.window.UpdateField);