<?php

/**
 * See https://github.com/JayBizzle/Crawler-Detect
 */

use Jaybizzle\CrawlerDetect\CrawlerDetect;

class PolylangUserAgentCrawlerDetector extends PolylangCrawlerDetector
{

    /** @var CrawlerDetect $crawlerDetect */
    protected $crawlerDetect;

    /**
     * @param array $config
     *
     * @return bool
     */
    protected function initialize(array $config = array())
    {
        parent::initialize($config);
        $this->crawlerDetect = new CrawlerDetect();
        return true;
    }

    /**
     * @param string|null $userAgent
     *
     * @return bool
     */
    public function isCrawler(string $userAgent = null)
    {
        return $this->crawlerDetect->isCrawler($userAgent);
    }
}
