<?php

class PolylangPolylangContentEnableProcessor extends modObjectUpdateProcessor
{
    public $languageTopics = array('polylang:default');
    public $classKey = 'PolylangContent';
    /** @var Polylang $polylang */
    public $polylang;
    /** @var PolylangTools $tools */
    public $tools;

    public function initialize()
    {
        $this->polylang = $this->modx->getService('polylang', 'Polylang');
        $this->tools = $this->polylang->getTools();
        return parent::initialize();
    }

    public function beforeSet()
    {
        $this->setProperty('active', 1);
        return true;
    }

    public function afterSave()
    {
        $canSave = parent::afterSave();
        if ($canSave) {
            $this->tools->clearCacheHasError404($this->object->get('content_id'), $this->object->get('culture_key'));
        }
        return $canSave;
    }

}

return 'PolylangPolylangContentEnableProcessor';