<?php

class PolylangPolylangSeoFieldsCreateProcessor extends modObjectCreateProcessor
{
    public $classKey = 'PolylangSeoFields';
    public $languageTopics = array('polylang:default');
    public $permission = 'polylang_polylangseofields_save';
    /** @var Polylang $polylang */
    public $polylang;

    public function initialize()
    {
        if (!$this->modx->hasPermission($this->permission)) {
            return $this->modx->lexicon('access_denied');
        }
        // $this->polylang = $this->modx->getService('polylang', 'Polylang');
        return parent::initialize();
    }

    public function beforeSave()
    {
        $name = $this->getProperty('name');
        if ($this->modx->getCount($this->classKey, array('name' => $name))) {
            $this->addFieldError('name', $this->modx->lexicon('polylang_polylangseofields_err_name_exists'));
        }
        return !$this->hasErrors();
    }

}

return 'PolylangPolylangSeoFieldsCreateProcessor';