<?php

class PolylangPolylangSeoFieldsGetListProcessor extends modObjectGetListProcessor
{
    public $classKey = 'PolylangSeoFields';
    public $languageTopics = array('polylang:default');
    public $defaultSortField = 'id';
    public $defaultSortDirection = 'ASC';
    public $permission = 'polylang_polylangseofields_list';
    /** @var Polylang $polylang */
    public $polylang;

    public function initialize()
    {
        if (!$this->modx->hasPermission($this->permission)) {
            return $this->modx->lexicon('access_denied');
        }
        // $this->polylang = $this->modx->getService('polylang', 'Polylang');
        return parent::initialize();
    }

    public function prepareQueryBeforeCount(xPDOQuery $c)
    {
        $query = $this->getProperty('query');

        if (!empty($query)) {
            $c->where(array(
                '`name`:LIKE' => '%' . $query . '%',
                'OR:`description`:LIKE' => '%' . $query . '%',
            ));
        }

        return $c;
    }

    public function prepareRow(xPDOObject $object)
    {
        $data = $object->toArray();

        if (!$this->getProperty('combo')) {
            $data['actions'] = array(
                array(
                    'cls' => array(
                        'menu' => 'green',
                        'button' => 'green',
                    ),
                    'icon' => 'icon icon-edit',
                    'title' => $this->modx->lexicon('polylang_polylangseofields_menu_update'),
                    'action' => 'updateItem',
                    'button' => true,
                    'menu' => true,
                )
            );

            if (!$data['active']) {
                $data['actions'][] = array(
                    'cls' => array(
                        'menu' => 'yellow',
                        'button' => 'yellow',
                    ),
                    'icon' => 'icon icon-power-off',
                    'title' => $this->modx->lexicon('polylang_polylangseofields_menu_enable'),
                    'multiple' => $this->modx->lexicon('polylang_polylangseofields_menu_multiple_enable'),
                    'action' => 'enableItem',
                    'button' => true,
                    'menu' => true,
                );
            } else {
                $data['actions'][] = array(
                    'cls' => array(
                        'menu' => 'gray',
                        'button' => 'gray',
                    ),
                    'icon' => 'icon icon-power-off',
                    'title' => $this->modx->lexicon('polylang_polylangseofields_menu_disable'),
                    'multiple' => $this->modx->lexicon('polylang_polylangseofields_menu_multiple_disable'),
                    'action' => 'disableItem',
                    'button' => true,
                    'menu' => true,
                );
            }
            $data['actions'][] = array(
                'cls' => array(
                    'menu' => 'red',
                    'button' => 'red',
                ),
                'icon' => 'icon icon-trash-o',
                'title' => $this->modx->lexicon('polylang_polylangseofields_menu_remove'),
                'multiple' => $this->modx->lexicon('polylang_polylangseofields_menu_multiple_remove'),
                'action' => 'removeItem',
                'button' => true,
                'menu' => true,
            );

        }

        return $data;
    }
}

return 'PolylangPolylangSeoFieldsGetListProcessor';