<?php

class PolylangPolylangSeoPatternGetProcessor extends modObjectGetProcessor
{
    public $classKey = 'PolylangSeoPattern';
    public $languageTopics = array('polylang:default');
    public $permission = 'polylang_polylangseopattern_view';
    /** @var Polylang $polylang */
    public $polylang;
    /** @var PolylangTools $tools */
    public $tools;


    public function initialize()
    {
        if (!$this->modx->hasPermission($this->permission)) {
            return $this->modx->lexicon('access_denied');
        }
        $this->polylang = $this->modx->getService('polylang', 'Polylang');
        $this->tools = $this->polylang->getTools();
        return parent::initialize();
    }

    /**
     * Return the response
     * @return array
     */
    public function cleanup()
    {
        $data = $this->object->toArray();
        $templateIds = $this->tools->getSeoTemplateIds($data['id']);
        $data['template'] = implode(',', $templateIds);
        return $this->success('', $data);
    }


}

return 'PolylangPolylangSeoPatternGetProcessor';