<?php

class PolylangPolylangSeoPatternGetListProcessor extends modObjectGetListProcessor
{
    public $classKey = 'PolylangSeoPattern';
    public $languageTopics = array('polylang:default');
    public $defaultSortField = 'id';
    public $defaultSortDirection = 'ASC';
    public $permission = 'polylang_polylangseopattern_list';
    /** @var Polylang $polylang */
    public $polylang;
    /** @var PolylangTools $tools */
    public $tools;

    public function initialize()
    {
        if (!$this->modx->hasPermission($this->permission)) {
            return $this->modx->lexicon('access_denied');
        }
        $this->polylang = $this->modx->getService('polylang', 'Polylang');
        $this->tools = $this->polylang->getTools();

        return parent::initialize();
    }

    public function beforeQuery()
    {
        if ($this->getProperty('combo')) {
            $this->setProperty('limit', 0);
        }

        return parent::beforeQuery();
    }

    public function prepareQueryBeforeCount(xPDOQuery $c)
    {

        $c->leftJoin('PolylangSeoFields', 'Fields', "`Fields`.`id` = `{$this->classKey}`.`field_id`");
        $c->leftJoin('PolylangLanguage', 'Language', "`Language`.`id` = `{$this->classKey}`.`language_id`");

        $c->select($this->modx->getSelectColumns($this->classKey, $this->classKey));
        $c->select($this->modx->getSelectColumns('PolylangSeoFields', 'Fields', 'field_', array('name')));
        $c->select($this->modx->getSelectColumns('PolylangLanguage', 'Language', 'language_', array('name', 'culture_key')));

        $query = $this->getProperty('query');
        $language = $this->getProperty('language');

        if (!empty($query)) {
            $c->where(array(
                '`Fields`.`name`:LIKE' => '%' . $query . '%',
                // 'OR:`code`:LIKE' => '%' . $query . '%',
            ));
        }
        if ($language) {
            $c->where(array(
                '`Language`.`id`' => $language,
            ));
        }

        return $c;
    }


    /**
     * @param int $patternId
     *
     * @return array
     */
    public function getTemplates($patternId)
    {
        $result = array();
        $templates = $this->tools->getSeoTemplates($patternId);
        foreach ($templates as $template) {
            $result[] = $template['templatename'];
        }
        return $result;
    }

    public function prepareRow(xPDOObject $object)
    {
        $data = $object->toArray();
        if (!$this->getProperty('combo')) {
            $data['template'] = implode('; ', $this->getTemplates($data['id']));
            $data['actions'] = array(
                array(
                    'cls' => array(
                        'menu' => 'green',
                        'button' => 'green',
                    ),
                    'icon' => 'icon icon-edit',
                    'title' => $this->modx->lexicon('polylang_polylangseopattern_menu_update'),
                    'action' => 'updateItem',
                    'button' => true,
                    'menu' => true,
                ),
                array(
                    'cls' => array(
                        'menu' => 'blue',
                        'button' => 'blue',
                    ),
                    'icon' => 'icon icon-clone',
                    'title' => $this->modx->lexicon('polylang_polylangseopattern_menu_clone'),
                    'multiple' => $this->modx->lexicon('polylang_polylangseopattern_menu_clone'),
                    'action' => 'cloneItem',
                    'button' => true,
                    'menu' => true,
                )
            );
            if (!$data['active']) {
                $data['actions'][] = array(
                    'cls' => array(
                        'menu' => 'yellow',
                        'button' => 'yellow',
                    ),
                    'icon' => 'icon icon-power-off',
                    'title' => $this->modx->lexicon('polylang_polylangseopattern_menu_enable'),
                    'multiple' => $this->modx->lexicon('polylang_polylangseopattern_menu_multiple_enable'),
                    'action' => 'enableItem',
                    'button' => true,
                    'menu' => true,
                );
            } else {
                $data['actions'][] = array(
                    'cls' => array(
                        'menu' => 'gray',
                        'button' => 'gray',
                    ),
                    'icon' => 'icon icon-power-off',
                    'title' => $this->modx->lexicon('polylang_polylangseopattern_menu_disable'),
                    'multiple' => $this->modx->lexicon('polylang_polylangseopattern_menu_multiple_disable'),
                    'action' => 'disableItem',
                    'button' => true,
                    'menu' => true,
                );
            }
            $data['actions'][] = array(
                'cls' => array(
                    'menu' => 'red',
                    'button' => 'red',
                ),
                'icon' => 'icon icon-trash-o',
                'title' => $this->modx->lexicon('polylang_polylangseopattern_menu_remove'),
                'multiple' => $this->modx->lexicon('polylang_polylangseopattern_menu_multiple_remove'),
                'action' => 'removeItem',
                'button' => true,
                'menu' => true,
            );
        }

        return $data;
    }
}

return 'PolylangPolylangSeoPatternGetListProcessor';