<?php
header('Content-Type: application/json; charset=UTF-8');

define('MODX_API_MODE', true);
require_once dirname(dirname(dirname(dirname(__FILE__)))) . '/index.php';

/** @var modX $modx */
$modx->getService('error', 'error.modError');
$modx->setLogLevel(modX::LOG_LEVEL_ERROR);
$modx->setLogTarget('FILE');

/** @var Polylang $polylang */
$polylang = $modx->getService('polylang', 'Polylang');
$polylang->config['prepareResponse'] = true;
$_REQUEST = array_merge($_POST, $_GET, $polylang->collectRequestParameters());

if (!$response = $polylang->runProcessor($_REQUEST['action'], $_REQUEST)) {
    $response = $modx->toJSON(array(
        'success' => false,
        'code' => 401,
    ));
    $modx->log(modX::LOG_LEVEL_ERROR, 'failed to run processor');
}

echo $response;
session_write_close();