<?php

/**
 * @var array $options
 * @var Modx $modx
 */

$exists = false;
$output = null;
$pkgName = 'Polylang';
$pkgNameLower = mb_strtolower($pkgName);
$modelPath = $modx->getOption("{$pkgNameLower}.core_path", null, $modx->getOption('core_path') . "components/{$pkgNameLower}/") . 'model/';
$mapFile = $modelPath . 'polylang/mysql/polylangproduct.map.inc.php';
$mapTmpFile = $modelPath . 'polylang/mysql/polylangproduct.map.inc.tmp.php';

switch ($options[xPDOTransport::PACKAGE_ACTION]) {
    case xPDOTransport::ACTION_INSTALL:
    case xPDOTransport::ACTION_UPGRADE:
        if (file_exists($mapFile)) {
            $modx->cacheManager->copyFile($mapFile, $mapTmpFile);
        }

        $exists = $modx->getObject('transport.modTransportPackage', array('package_name' => 'pdoTools'));
        switch ($modx->getOption('manager_language')) {
            case 'ru':
                $overridePdoFetch = 'Переопределить класс pdoFetch.<br/><small>Необходимо для поддержки сниппетами пакета pdoTools переведенных полей.</small>';
                break;
            default:
                $overridePdoFetch = 'Override the pdoFetch class. <br/><small>Required for pdoTools snippets to support translated fields.</small>';
        }

        $list = '<ul id="formCheckboxes" style="height:200px;overflow:auto;">';
        $list .= '<li>
					<label>
						<input type="checkbox" name="overridePdoFetch" value="1" checked> ' . $overridePdoFetch . '
					</label>
				</li>';
        $list .= '</ul>';

        break;
}

$output = '';
if (!$exists) {
    switch ($modx->getOption('manager_language')) {
        case 'ru':
            $output = 'Этот компонент требует <b>pdoTools</b> для быстрой работы сниппетов.<br/>Он будет автоматически скачан и установлен.';
            break;
        default:
            $output = 'This component requires <b>pdoTools</b> for fast work of snippets.<br/><br/>It will be automatically downloaded and installed.';
    }
}

if ($list) {
    if (!$exists) {
        $output .= '<br/><br/>';
    }
    $output .= $list;
}
return $output;