<?php
/**
 * Polylang
 * @package polylang
 * @var modX $modx
 * @var Polylang $polylang
 * @var PolylangTools $tools
 * @var array $scriptProperties
 */

$polylang = $modx->getService('polylang', 'Polylang');
$tools = $polylang->getTools();

$docid = $modx->getOption('docid', $scriptProperties, $modx->resource->get('id'));
if ($docid && !$tools->isCurrentDefaultLanguage()) {
    $cultureKey = $modx->getOption('cultureKey');
    $tvname = $modx->getOption('tvname', $scriptProperties);
    $doc = $modx->getObject('PolylangContent', array(
        'content_id' => $docid,
        'culture_key' => $cultureKey
    ));
    if ($doc && $tvname) {
        $scriptProperties['value'] = $doc->get($tvname);
    }
}
return $modx->runSnippet('getImageList', $scriptProperties);