<?php

interface PolylangCrawlerDetectorInterface
{

    /** @return bool */
    public function isCrawler();

}

abstract class PolylangCrawlerDetector implements PolylangCrawlerDetectorInterface
{
    /** @var modX */
    protected $modx = null;
    /** @var Polylang $polylang */
    public $polylang = null;
    /** @var array $config */
    protected $config = array();
    /** @var bool $initialized */
    protected $initialized = false;


    public function __construct(Polylang $polylang, $config = array())
    {
        $this->polylang = $polylang;
        $this->modx = $polylang->modx;
        $this->config = array_merge($this->config, $config);
        $this->initialized = $this->initialize();
    }

    /**
     * @param array $config
     *
     * @return bool
     */
    protected function initialize(array $config = array())
    {
        $this->config = array_merge($this->config, $config);
        return true;
    }

}
