<?php

class PolylangLexiconEntriesCloneProcessor extends modProcessor
{
    public $classKey = 'LexiconEntries';
    public $permission = 'polylang_lexicon_clone';
    /** @var Polylang $polylang */
    public $polylang;
    /** @var PolylangTools $tools */
    public $tools;

    public function initialize()
    {
        if (!$this->modx->hasPermission($this->permission)) {
            return $this->modx->lexicon('access_denied');
        }
        $initialized = parent::initialize();
        if ($initialized) {
            $this->polylang = $this->modx->getService('polylang', 'Polylang');
            $this->tools = $this->polylang->getTools();
            $this->setDefaultProperties(array(
                'namespace' => 'polylang',
                'topic' => 'site',
            ));
        }
        return $initialized;
    }

    public function getLanguageTopics()
    {
        return array('polylang:default');
    }

    public function process()
    {
        $lexicons = array();
        $all = $this->getProperty('all');
        $language = $this->getProperty('language');
        $languages = $this->getProperty('languages');
        $data = $this->tools->getLexicons($language);
        $skipExisting = $this->getProperty('skip_existing', true);
        if (!$all) {
            $lexicons = $this->getProperty('lexicons');
            $lexicons = $this->tools->fromJSON($lexicons, array());
            if (empty($lexicons)) {
                return $this->failure();
            }
        }
        if ($data) {
            foreach ($data as $item) {
                if ($skipExisting && $lexicons && !in_array($item['name'], $lexicons)) {
                    continue;
                }
                $lexicon = array(
                    'name' => $item['name'],
                    'topic' => $item['topic'],
                    'namespace' => $item['namespace'],
                );
                foreach ($languages as $key => $val) {
                    if (!$val) continue;
                    $lexicon['language'] = $key;
                    $this->copy($item['value'], $lexicon);
                }
            }
        }
        return $this->success();
    }

    /**
     * @param string $value
     * @param array $lexicon
     * @param bool $skipExisting
     */
    public function copy($value, array $lexicon, $skipExisting = false)
    {
        $entry = $this->modx->getObject('modLexiconEntry', $lexicon);
        if ($entry) {
            if ($skipExisting) return;
            $entry->set('editedon', date('Y-m-d H:i:s'));
        } else {
            $entry = $this->modx->newObject('modLexiconEntry', $lexicon);
            $entry->set('createdon', date('Y-m-d H:i:s'));
        }
        $entry->set('value', $value);
        if ($entry->save()) {
            $entry->clearCache();
        } else {
            $this->modx->log(modX::LOG_LEVEL_ERROR, 'Error save lexicon:' . print_r($lexicon, 1));
        }
    }
}

return 'PolylangLexiconEntriesCloneProcessor';