<?php

class PolylangLexiconEntriesExportProcessor extends modProcessor
{
    public $classKey = 'LexiconEntries';
    public $permission = 'polylang_lexicon_export';
    /** @var Polylang $polylang */
    public $polylang;
    /** @var PolylangTools $tools */
    public $tools;
    /** @var array */
    protected $lexicons = array();

    public function initialize()
    {
        if (!$this->modx->hasPermission($this->permission)) {
            return $this->modx->lexicon('access_denied');
        }
        $initialized = parent::initialize();
        if ($initialized) {
            $this->polylang = $this->modx->getService('polylang', 'Polylang');
            $this->tools = $this->polylang->getTools();
            $this->setDefaultProperties(array(
                'namespace' => 'polylang',
                'topic' => 'site',
            ));
        }
        return $initialized;
    }

    public function getLanguageTopics()
    {
        return array('polylang:default');
    }

    public function process()
    {
        $download = $this->getProperty('download');
        if (empty($download)) {
            return $this->cache();
        }
        return $this->download();
    }

    /**
     * Cache the data to an export file
     * @return array|string
     */
    public function cache()
    {
        $languages = $this->getProperty('languages');
        if ($languages) {
            foreach ($languages as $key => $val) {
                if (!$val) continue;
                $items = $this->tools->getLexicons($key);
                if ($items) {
                    foreach ($items as $item) {
                        $lexicon = array(
                            'name' => $item['name'],
                            'value' => $item['value'],
                            'topic' => $item['topic'],
                            'namespace' => $item['namespace'],
                            'language' => $item['language'],
                        );
                        $this->lexicons[$key][] = $lexicon;
                    }
                }
            }
        }
        $fileName = 'lexicons.json';
        $file = $this->getPath() . $fileName;
        $this->modx->cacheManager->writeFile($file, $this->modx->toJSON($this->lexicons));
        return $this->success($fileName);
    }

    /**
     * Attempt to download the exported file to the browser
     * @return mixed
     */
    public function download()
    {
        $fileName = $this->getProperty('file');
        $file = $this->getPath() . $fileName;
        $this->modx->getService('fileHandler', 'modFileHandler');
        $fileObj = $this->modx->fileHandler->make($file);
        if (!$fileObj->exists()) return $this->failure($file);
        $fileObj->download(array('filename' => $fileName));
    }


    /**
     * @return string
     */
    public function getPath()
    {
        return $this->modx->getOption('core_path', null, MODX_CORE_PATH) . 'export/lexicons/';
    }

}

return 'PolylangLexiconEntriesExportProcessor';