<?php

class PolylangPolylangSeoFieldsUpdateProcessor extends modObjectUpdateProcessor
{
    public $classKey = 'PolylangSeoFields';
    public $languageTopics = array('polylang:default');
    public $permission = 'polylang_polylangseofields_save';
    /** @var Polylang $polylang */
    public $polylang;

    public function initialize()
    {
        if (!$this->modx->hasPermission($this->permission)) {
            return $this->modx->lexicon('access_denied');
        }
        // $this->polylang = $this->modx->getService('polylang', 'Polylang');
        return parent::initialize();
    }

    public function beforeSave()
    {
        $id = $this->object->get('id');
        $name = $this->getProperty('name');
        if ($this->modx->getCount($this->classKey, array('name' => $name, 'id:!=' => $id))) {
            $this->addFieldError('name', $this->modx->lexicon('polylang_polylangseofields_err_name_exists'));
        }
        return !$this->hasErrors();
    }

}

return 'PolylangPolylangSeoFieldsUpdateProcessor';