<?php

use Prihod\Translate\Translator;
use Prihod\Translate\Exception;

class PolylangTranslatorPromt extends PolylangTranslatorHandler
{
    /** @var Translator|null $translator */
    public $translator = null;
    /** @var string */
    protected $profile;
    /** @var string */
    protected $format;

    public function __construct(Polylang &$polylang, $config = array())
    {
        parent::__construct($polylang, $config);
        $apiConfig = $this->modx->getOption('polylang_translate_promt_config', $config, '{}', true);
        $apiConfig = $this->modx->fromJSON($apiConfig);
        $this->profile = $this->modx->getOption('profile', $apiConfig, '');
        $this->format = $this->modx->getOption('format', $apiConfig, 'text/html');
        if (empty($apiConfig['key'])) {
            $this->modx->log(modX::LOG_LEVEL_ERROR, 'Not set PROMT API key!');
        } else {
            $this->translator = new Translator($apiConfig['key']);
        }
    }

    /**
     * @param string $text
     * @param string $from
     * @param string $to
     * @param array $options
     *
     * @return string|false
     */
    public function translate(string $text, string $from, string $to, array $options = array())
    {
        if (!$this->translator) return false;
        try {
            if ($text) {
                $from = $this->prepareLanguageCode($from);
                $to = $this->prepareLanguageCode($to);
                $profile = $this->modx->getOption('profile', $options, $this->profile);
                $format = $this->modx->getOption('format', $options, $this->format);
                $text = $this->beforeTranslation($text);

                if ($this->isDetectSourceLanguage) {
                    if ($detectLang = $this->detectLanguage($text)) {
                        $from = $detectLang;

                        if ($this->tools->debug) {
                            $this->modx->log(modX::LOG_LEVEL_ERROR, "[Translate] Detected source language:{$from}");
                        }
                    }
                }

                $text = (string)$this->translator->translate($text, $from, $to, $profile, $format);
                $text = $this->afterTranslation($text);
            }
        } catch (Exception $e) {
            $this->modx->log(modX::LOG_LEVEL_ERROR, $e->getMessage());
            return false;
        }
        return $text;
    }

    /**
     * @param string $text
     *
     * @return false|string
     */
    public function detectLanguage(string $text)
    {
        try {
            if ($lang = $this->translator->detect($text)) {
                return $lang;
            }
        } catch (Exception $e) {
            $this->modx->log(modX::LOG_LEVEL_ERROR, 'Error detect language for text:' . $text . 'Info:' . $e->getMessage());
        }
        return false;
    }

    /**
     * @return bool
     */
    public function isInitialized()
    {
        return $this->translator !== null;
    }
}