<?php

class PolylangPolylangSeoFieldsMultipleProcessor extends modProcessor
{
    /** @var Polylang $polylang  */
    public $polylang ;
    public $languageTopics = array('polylang:default');

    public function initialize()
    {
        $this->polylang = $this->modx->getService('polylang', 'Polylang');
        return parent::initialize();
    }

    /**
     * @return array|string
     */
    public function process()
    {

        if (!$method = $this->getProperty('method', false)) {
            return $this->failure();
        }
        $key = $this->getProperty('key', 'id');
        $values = json_decode($this->getProperty('values'), true);
        if (empty($values)) {
            return $this->success();
        }

        foreach ($values as $value) {
            /** @var modProcessorResponse $response */
            $response = $this->modx->runProcessor(
                'mgr/polylangseofields/' . $method,
                array($key => $value),
                array('processors_path' => $this->polylang->config['processorsPath'])
            );
            if ($response->isError()) {
                return $response->getResponse();
            }
        }

        return $this->success();
    }

}

return 'PolylangPolylangSeoFieldsMultipleProcessor';